/*
 * Decompiled with CFR 0.152.
 */
package ru.pinkgoosik.cosmetica.data;

import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.loader.api.FabricLoader;
import ru.pinkgoosik.cosmetica.CosmeticaMod;
import ru.pinkgoosik.cosmetica.data.EntryData;

public class CosmeticaData {
    public static final List<EntryData> ENTRIES = new ArrayList<EntryData>();
    private static final String ENTRIES_DATA_URL = "https://pinkgoosik.ru/cosmetica/entries.json";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reload() {
        try {
            ENTRIES.clear();
            URL url = new URL(ENTRIES_DATA_URL);
            URLConnection request = url.openConnection();
            request.connect();
            InputStreamReader reader = new InputStreamReader(request.getInputStream());
            EntryData[] entries = (EntryData[])CosmeticaMod.GSON.fromJson((Reader)reader, EntryData[].class);
            ENTRIES.addAll(Arrays.asList(entries));
        }
        catch (Exception e) {
            ENTRIES.clear();
            if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
                CosmeticaMod.LOGGER.warn("Failed to load Cosmetica User Entries due to an exception:\n" + e);
            }
        }
        finally {
            if (!ENTRIES.isEmpty() && FabricLoader.getInstance().isDevelopmentEnvironment()) {
                CosmeticaMod.LOGGER.info("Cosmetica User Entries successfully loaded");
            }
        }
    }

    public static Optional<EntryData> getEntry(UUID uuid, String name) {
        for (EntryData entry : ENTRIES) {
            if (!uuid.equals(UUID.fromString(entry.user.uuid)) && !name.equals(entry.user.name)) continue;
            return Optional.of(entry);
        }
        return Optional.empty();
    }
}

